# Quick Start Guide

## Installation (5 Minutes)

1. **Import Database**
   ```bash
   mysql -u root -p task_management < database.sql
   ```

2. **Configure Database**
   - Edit `config.php`
   - Update DB_HOST, DB_USER, DB_PASS, DB_NAME

3. **Set Passwords**
   ```bash
   php setup_passwords.php
   ```

4. **Set Permissions**
   ```bash
   mkdir -p uploads
   chmod 755 uploads
   ```

5. **Access the System**
   - Open browser: `http://localhost/TaskManagement/`
   - Login with: admin / admin123

## Key Features Overview

### Admin Features
- ✅ Create and manage tasks
- ✅ Assign tasks to users
- ✅ View all users and their performance
- ✅ Generate progress reports
- ✅ View audit logs
- ✅ Delete tasks (with password verification)

### User Features
- ✅ View assigned tasks
- ✅ Complete tasks (earn +1.2 points)
- ✅ See real-time countdown timers
- ✅ Filter tasks by status and priority
- ✅ View points history
- ✅ Add notes and attachments to tasks
- ✅ View completion history

## Task Types

### One-Time Tasks
- Created once
- Completed once
- Points awarded on completion

### Recurring Tasks
- Automatically recreate after completion
- Set recurrence interval (in days)
- New instance created automatically

## Points System

- **Complete Task:** +1.2 points
- **Incomplete/Overdue:** -1.0 points
- Track all points in "My History"

## Priority Levels

- **High:** Red badge, shown first
- **Medium:** Yellow badge
- **Low:** Green badge

## Task Status

- **Pending:** Not started
- **In Progress:** Being worked on
- **Completed:** Finished (points awarded)
- **Overdue:** Past due date (points deducted)

## Navigation

### Admin Navigation
- Admin Dashboard → Overview
- Create Task → Add new tasks
- Manage Tasks → View/Delete all tasks
- Manage Users → Create/View users
- Reports → Progress reports
- Audit Logs → Activity tracking

### User Navigation
- Dashboard → My tasks
- My History → Points and completion history
- View Task → Task details, notes, attachments

## Tips

1. **Set up cron job** for automatic recurring tasks
2. **Use filters** to find specific tasks quickly
3. **Add notes** to provide context for tasks
4. **Check notifications** regularly for updates
5. **View reports** to track progress over time

## Support

See `README.md` for detailed documentation and `SETUP.md` for installation help.
