# Setup Guide

## Quick Setup Instructions

### Step 1: Database Setup

1. Create a MySQL database named `task_management`
2. Import the `database.sql` file:
   ```bash
   mysql -u your_username -p task_management < database.sql
   ```
   Or use phpMyAdmin to import the SQL file.

### Step 2: Configure Database Connection

Edit `config.php` and update these lines with your database credentials:

```php
define('DB_HOST', 'localhost');
define('DB_USER', 'your_username');
define('DB_PASS', 'your_password');
define('DB_NAME', 'task_management');
```

### Step 3: Set Up Passwords (Important!)

After importing the database, run the password setup script:

```bash
php setup_passwords.php
```

This will set proper password hashes for the default users.

**Default Credentials:**
- Admin: username `admin`, password `admin123`
- User: username `user1`, password `user123`

⚠️ **Change these passwords immediately after first login!**

### Step 4: Set File Permissions

```bash
chmod 755 uploads/
chmod 644 *.php
chmod 644 assets/css/*.css
```

### Step 5: Configure Web Server

#### Apache
- Ensure mod_rewrite is enabled
- Point document root to the project directory
- The `.htaccess` file is already included

#### Nginx
Add this to your server block:

```nginx
location / {
    try_files $uri $uri/ /index.php?$query_string;
}

location ~ \.php$ {
    fastcgi_pass unix:/var/run/php/php7.4-fpm.sock;
    fastcgi_index index.php;
    include fastcgi_params;
    fastcgi_param SCRIPT_FILENAME $document_root$fastcgi_script_name;
}
```

### Step 6: Set Up Cron Job (Optional but Recommended)

For automatic task scheduling and notifications, set up a cron job:

```bash
crontab -e
```

Add this line to run every hour:

```
0 * * * * /usr/bin/php /full/path/to/TaskManagement/cron_jobs.php >> /var/log/task_management_cron.log 2>&1
```

Replace `/full/path/to/TaskManagement/` with your actual project path.

### Step 7: Test the Installation

1. Open your browser and navigate to the project URL
2. You should see the home page
3. Click "Login" and try logging in with admin credentials
4. If successful, you're all set!

## Troubleshooting

### Can't connect to database
- Check database credentials in `config.php`
- Verify MySQL service is running
- Ensure database exists

### Passwords don't work
- Run `php setup_passwords.php` to reset passwords
- Or manually update passwords in the database

### File uploads not working
- Check `uploads/` directory exists and has write permissions
- Verify PHP upload settings in `php.ini`

### Cron jobs not running
- Check cron service is running: `systemctl status cron` (Linux) or `service cron status`
- Verify PHP path: `which php`
- Check cron logs: `grep CRON /var/log/syslog`

## Next Steps

1. Change default passwords
2. Create additional users via Admin Dashboard
3. Create your first task
4. Assign tasks to users
5. Start using the system!

## Security Recommendations

1. Change default passwords immediately
2. Use strong passwords for database
3. Keep PHP and MySQL updated
4. Regularly backup the database
5. Review audit logs periodically
6. Consider using HTTPS in production
