<?php
require_once 'config.php';
if (isLoggedIn()) {
    if (isAdmin()) {
        header('Location: admin_dashboard.php');
    } else {
        header('Location: dashboard.php');
    }
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, viewport-fit=cover">
    <title>Task Management System - Home</title>
    <link rel="stylesheet" href="assets/css/style.css">
    <script src="assets/js/theme.js"></script>
</head>
<body>
    <div class="header" style="margin-bottom: 0;">
        <h1 style="margin: 0 auto;">Task Management</h1>
        <label class="theme-toggle-label" style="position: absolute; right: 16px;">
            <span style="font-size: 14px;">🌙</span>
            <button type="button" id="theme-toggle" class="theme-toggle" onclick="toggleTheme()" aria-label="Toggle theme"></button>
            <span style="font-size: 14px;">☀️</span>
        </label>
    </div>
    <div class="container">
        <div class="welcome-section">
            <h1>Task Management System</h1>
            <p>Manage your tasks efficiently with our comprehensive task management solution</p>
            <div class="auth-buttons">
                <a href="login.php" class="btn btn-primary">Login</a>
            </div>
        </div>
    </div>
</body>
</html>
