<?php
// Mobile App Style Header Component
// Include this file in pages that need the mobile app header
if (!isLoggedIn()) return;

$user = getUserInfo();
$notification_count = getNotificationCount();
$header_notifications = getNotifications($_SESSION['user_id'], 10);
$is_admin = isAdmin();
?>
<!-- Mobile Sidebar -->
<div id="mobile-sidebar" class="mobile-sidebar">
    <div class="mobile-sidebar-header">
        <h3>Menu</h3>
        <button type="button" id="mobile-menu-close" class="mobile-menu-close" aria-label="Close">×</button>
    </div>
    <div class="mobile-sidebar-menu">
        <?php if ($is_admin): ?>
            <a href="admin_dashboard.php">Dashboard</a>
            <a href="create_task.php">Create Task</a>
            <a href="manage_tasks.php">Manage Tasks</a>
            <a href="manage_users.php">Manage Users</a>
            <a href="admin_reports.php">View Reports</a>
            <a href="audit_logs.php">Audit Logs</a>
        <?php else: ?>
            <a href="dashboard.php">Dashboard</a>
            <a href="my_history.php">My History</a>
        <?php endif; ?>
        <a href="logout.php">Logout</a>
    </div>
</div>
<div id="mobile-menu-overlay" class="mobile-menu-overlay"></div>

<!-- Mobile App Style Header -->
<div class="header mobile-app-header">
    <div class="header-left">
        <button type="button" id="mobile-menu-toggle" class="mobile-menu-toggle" aria-label="Menu">☰</button>
        <div class="header-subtitle"><?php echo $is_admin ? 'Admin logged in' : 'User logged in'; ?></div>
    </div>
    <div class="header-center">
        <div class="header-title">Task Management</div>
    </div>
    <div class="header-right">
        <div class="notification-container">
            <button type="button" id="notification-icon" class="notification-icon" aria-label="Notifications">
                🔔
                <?php if ($notification_count > 0): ?>
                    <span class="notification-badge"><?php echo $notification_count > 99 ? '99+' : $notification_count; ?></span>
                <?php else: ?>
                    <span class="notification-badge hidden">0</span>
                <?php endif; ?>
            </button>
            <div id="notification-dropdown" class="notification-dropdown">
                <div class="notification-header">
                    <h3>Notifications</h3>
                    <button type="button" class="notification-close" onclick="closeNotificationDropdown()" aria-label="Close">×</button>
                </div>
                <div class="notification-list">
                    <?php if (empty($header_notifications)): ?>
                        <div class="notification-empty">
                            <div class="notification-empty-icon">🔔</div>
                            <p>No notifications</p>
                        </div>
                    <?php else: ?>
                        <?php foreach ($header_notifications as $notif): 
                            $is_unread = $notif['is_read'] == 0;
                            $time_ago = time() - strtotime($notif['created_at']);
                            $time_text = '';
                            if ($time_ago < 60) {
                                $time_text = 'Just now';
                            } elseif ($time_ago < 3600) {
                                $time_text = floor($time_ago / 60) . 'm ago';
                            } elseif ($time_ago < 86400) {
                                $time_text = floor($time_ago / 3600) . 'h ago';
                            } else {
                                $time_text = floor($time_ago / 86400) . 'd ago';
                            }
                        ?>
                            <div class="notification-item <?php echo $is_unread ? 'unread' : 'read'; ?>" data-notification-id="<?php echo $notif['id']; ?>">
                                <div class="notification-type"><?php echo htmlspecialchars(ucfirst(str_replace('_', ' ', $notif['notification_type']))); ?></div>
                                <div class="notification-message"><?php echo htmlspecialchars($notif['message']); ?></div>
                                <div class="notification-time"><?php echo $time_text; ?></div>
                            </div>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>
                <?php if (!empty($header_notifications)): ?>
                    <div class="notification-footer">
                        <a href="<?php echo $is_admin ? 'admin_dashboard.php' : 'dashboard.php'; ?>#notifications">View All</a>
                    </div>
                <?php endif; ?>
            </div>
            <div id="notification-overlay" class="notification-overlay"></div>
        </div>
        <div class="header-subtitle"><?php echo htmlspecialchars($user['full_name']); ?></div>
    </div>
</div>
