<?php
require_once 'config.php';
requireLogin();

$conn = getDBConnection();
$user = getUserInfo();

// Get points history
$points_history = $conn->prepare("SELECT ph.*, t.task_name FROM points_history ph LEFT JOIN tasks t ON ph.task_id = t.id WHERE ph.user_id = ? ORDER BY ph.created_at DESC");
$points_history->bind_param("i", $_SESSION['user_id']);
$points_history->execute();
$points_history = $points_history->get_result()->fetch_all(MYSQLI_ASSOC);

// Get completion history
$completion_history = $conn->prepare("SELECT tch.*, t.task_name FROM task_completion_history tch LEFT JOIN tasks t ON tch.task_id = t.id WHERE tch.user_id = ? ORDER BY tch.completed_at DESC");
$completion_history->bind_param("i", $_SESSION['user_id']);
$completion_history->execute();
$completion_history = $completion_history->get_result()->fetch_all(MYSQLI_ASSOC);

// Get all tasks (completed and incomplete)
$all_tasks = $conn->prepare("SELECT * FROM tasks WHERE assigned_to = ? ORDER BY created_at DESC");
$all_tasks->bind_param("i", $_SESSION['user_id']);
$all_tasks->execute();
$all_tasks = $all_tasks->get_result()->fetch_all(MYSQLI_ASSOC);

// Calculate statistics
$total_points_earned = array_sum(array_column(array_filter($points_history, fn($p) => $p['points'] > 0), 'points'));
$total_points_lost = abs(array_sum(array_column(array_filter($points_history, fn($p) => $p['points'] < 0), 'points')));
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, viewport-fit=cover">
    <title>My History - Task Management System</title>
    <link rel="stylesheet" href="assets/css/style.css">
    <script src="assets/js/theme.js"></script>
    <script src="assets/js/notifications.js"></script>
    <script src="assets/js/mobile-menu.js"></script>
</head>
<body class="mobile-app">
    <?php include 'mobile_header.php'; ?>

    <div class="container">
        <!-- Statistics -->
        <div class="stats-grid">
            <div class="stat-card">
                <div class="stat-value" style="color: green;">+<?php echo number_format($total_points_earned, 2); ?></div>
                <div class="stat-label">Points Earned</div>
            </div>
            <div class="stat-card">
                <div class="stat-value" style="color: red;">-<?php echo number_format($total_points_lost, 2); ?></div>
                <div class="stat-label">Points Lost</div>
            </div>
            <div class="stat-card">
                <div class="stat-value"><?php echo count($completion_history); ?></div>
                <div class="stat-label">Tasks Completed</div>
            </div>
            <div class="stat-card">
                <div class="stat-value"><?php echo count($all_tasks); ?></div>
                <div class="stat-label">Total Tasks</div>
            </div>
        </div>
        
        <!-- Points History -->
        <div class="card">
            <div class="card-header">
                <h2 class="card-title">Points History</h2>
            </div>
            <div class="table-container">
                <table>
                    <thead>
                        <tr>
                            <th>Date</th>
                            <th>Points</th>
                            <th>Reason</th>
                            <th>Task</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (empty($points_history)): ?>
                            <tr>
                                <td colspan="4" class="empty-state">No points history</td>
                            </tr>
                        <?php else: ?>
                            <?php foreach ($points_history as $ph): ?>
                                <tr>
                                    <td><?php echo date('M d, Y H:i', strtotime($ph['created_at'])); ?></td>
                                    <td style="color: <?php echo $ph['points'] > 0 ? 'green' : 'red'; ?>; font-weight: bold;">
                                        <?php echo $ph['points'] > 0 ? '+' : ''; ?><?php echo number_format($ph['points'], 2); ?>
                                    </td>
                                    <td><?php echo htmlspecialchars($ph['reason']); ?></td>
                                    <td><?php echo htmlspecialchars($ph['task_name'] ?? 'N/A'); ?></td>
                                </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
        
        <!-- Completion History -->
        <div class="card">
            <div class="card-header">
                <h2 class="card-title">Task Completion History</h2>
            </div>
            <div class="table-container">
                <table>
                    <thead>
                        <tr>
                            <th>Date</th>
                            <th>Task</th>
                            <th>Points Earned</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (empty($completion_history)): ?>
                            <tr>
                                <td colspan="3" class="empty-state">No completion history</td>
                            </tr>
                        <?php else: ?>
                            <?php foreach ($completion_history as $ch): ?>
                                <tr>
                                    <td><?php echo date('M d, Y H:i', strtotime($ch['completed_at'])); ?></td>
                                    <td><?php echo htmlspecialchars($ch['task_name'] ?? 'N/A'); ?></td>
                                    <td style="color: green; font-weight: bold;">+<?php echo number_format($ch['points_earned'], 2); ?></td>
                                </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
        
        <!-- All Tasks History -->
        <div class="card">
            <div class="card-header">
                <h2 class="card-title">All Tasks History</h2>
            </div>
            <div class="table-container">
                <table>
                    <thead>
                        <tr>
                            <th>Task Name</th>
                            <th>Priority</th>
                            <th>Status</th>
                            <th>Created</th>
                            <th>Due Date</th>
                            <th>Completed</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (empty($all_tasks)): ?>
                            <tr>
                                <td colspan="7" class="empty-state">No tasks found</td>
                            </tr>
                        <?php else: ?>
                            <?php foreach ($all_tasks as $task): ?>
                                <tr>
                                    <td><?php echo htmlspecialchars($task['task_name']); ?></td>
                                    <td><span class="priority-badge priority-<?php echo $task['priority']; ?>"><?php echo ucfirst($task['priority']); ?></span></td>
                                    <td><span class="status-badge status-<?php echo $task['status']; ?>"><?php echo ucfirst(str_replace('_', ' ', $task['status'])); ?></span></td>
                                    <td><?php echo date('M d, Y', strtotime($task['created_at'])); ?></td>
                                    <td><?php echo $task['due_date'] ? date('M d, Y H:i', strtotime($task['due_date'])) : 'N/A'; ?></td>
                                    <td><?php echo $task['completed_at'] ? date('M d, Y H:i', strtotime($task['completed_at'])) : 'N/A'; ?></td>
                                    <td>
                                        <a href="view_task.php?id=<?php echo $task['id']; ?>" class="btn btn-primary btn-sm">View</a>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</body>
</html>
