<?php
// Notification Header Component
// Include this file in pages that need notification icon
if (!isLoggedIn()) return;

$notification_count = getNotificationCount();
$header_notifications = getNotifications($_SESSION['user_id'], 10);
?>
<div class="notification-container">
    <button type="button" id="notification-icon" class="notification-icon" aria-label="Notifications">
        🔔
        <?php if ($notification_count > 0): ?>
            <span class="notification-badge"><?php echo $notification_count > 99 ? '99+' : $notification_count; ?></span>
        <?php else: ?>
            <span class="notification-badge hidden">0</span>
        <?php endif; ?>
    </button>
    <div id="notification-dropdown" class="notification-dropdown">
        <div class="notification-header">
            <h3>Notifications</h3>
            <button type="button" class="notification-close" onclick="closeNotificationDropdown()" aria-label="Close">×</button>
        </div>
        <div class="notification-list">
            <?php if (empty($header_notifications)): ?>
                <div class="notification-empty">
                    <div class="notification-empty-icon">🔔</div>
                    <p>No notifications</p>
                </div>
            <?php else: ?>
                <?php foreach ($header_notifications as $notif): 
                    $is_unread = $notif['is_read'] == 0;
                    $time_ago = time() - strtotime($notif['created_at']);
                    $time_text = '';
                    if ($time_ago < 60) {
                        $time_text = 'Just now';
                    } elseif ($time_ago < 3600) {
                        $time_text = floor($time_ago / 60) . 'm ago';
                    } elseif ($time_ago < 86400) {
                        $time_text = floor($time_ago / 3600) . 'h ago';
                    } else {
                        $time_text = floor($time_ago / 86400) . 'd ago';
                    }
                ?>
                    <div class="notification-item <?php echo $is_unread ? 'unread' : 'read'; ?>" data-notification-id="<?php echo $notif['id']; ?>">
                        <div class="notification-type"><?php echo htmlspecialchars(ucfirst(str_replace('_', ' ', $notif['notification_type']))); ?></div>
                        <div class="notification-message"><?php echo htmlspecialchars($notif['message']); ?></div>
                        <div class="notification-time"><?php echo $time_text; ?></div>
                    </div>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>
        <?php if (!empty($header_notifications)): ?>
            <div class="notification-footer">
                <a href="<?php echo isAdmin() ? 'admin_dashboard.php' : 'dashboard.php'; ?>#notifications">View All</a>
            </div>
        <?php endif; ?>
    </div>
    <div id="notification-overlay" class="notification-overlay"></div>
</div>
