<?php
/**
 * Password Setup Script
 * Run this once to set up proper password hashes for default users
 * 
 * Usage: php setup_passwords.php
 */

require_once 'config.php';

$conn = getDBConnection();

// Update admin password
$admin_password = 'admin123';
$stmt = $conn->prepare("UPDATE users SET password = ? WHERE username = 'admin'");
$stmt->bind_param("s", $admin_password);
$stmt->execute();
echo "Admin password updated successfully!\n";

// Update user password
$user_password = 'user123';
$stmt = $conn->prepare("UPDATE users SET password = ? WHERE username = 'user1'");
$stmt->bind_param("s", $user_password);
$stmt->execute();
echo "User password updated successfully!\n";

echo "\nDefault credentials:\n";
echo "Admin - Username: admin, Password: admin123\n";
echo "User - Username: user1, Password: user123\n";
echo "\n⚠️  Please change these passwords after first login!\n";
?>
